#include <stdio.h> 

ENV

/* message types */
#define CNTL            0
#define DATA            1
#define END_SIGNAL      2

BEGIN_MSG_TYPES
    MSG_TYPE(CNTL,
        struct cntl_rec {
                PROC_ID prev;
		PROC_ID next;
        };
    )

    MSG_TYPE(DATA,
        struct data_rec {
                int ln;
                char buf[1000];
        };
    )

    MSG_TYPE(END_SIGNAL,EMPTY)
END_MSG_TYPES

main()
{
    PROC_ID master_id, sender_id;
    int msg_type;

    struct cntl_rec rec1;

    struct data_rec rec2;

    int ln;
	syslog(0,"Before initenv ");

	INITENV

	syslog(0,"After initenv ");

    /*
       Get successor's id
    */
    RECEIVE(&master_id, &msg_type, &rec1, match_type(CNTL))

    /*
       Loop on receiving messages and sending them down the pipe
       until message of type 2 is received.
    */
    while (msg_type != 2) {
        RECEIVE(&sender_id, &msg_type, &rec2,
		(match_id(&rec1.prev) && 
		 (match_type(DATA) || match_type(END_SIGNAL))),
                &ln)

        if (msg_type == DATA) {
            SENDR(&rec1.next, msg_type, &rec2, ln)
        }
        else {
            SENDR(&rec1.next, END_SIGNAL)
        }
    }
}
